;Written by Iain McCurdy, 2009


; Modified for QuteCsound by René, November 2010
; Tested on Ubuntu 10.04 with csound-double cvs August 2010 and QuteCsound svn rev 733

;Notes on modifications from original csd:
;	Add table(s) for exp slider
;	Instrument 1 is activated by MIDI and by the GUI


;my flags on Ubuntu: -odac -b1024 -B2048 -+rtaudio=alsa -+rtmidi=alsa -Ma -m0 --midi-key-oct=4 --midi-velocity-amp=5
<CsoundSynthesizer>
<CsOptions>

</CsOptions>
<CsInstruments>
sr 		= 44100	;SAMPLE RATE
ksmps 	= 1		;NUMBER OF AUDIO SAMPLES IN EACH CONTROL CYCLE
nchnls	= 2		;NUMBER OF CHANNELS (2=STEREO)
0dbfs	= 1		;MAXIMUM AMPLITUDE REGARDLESS OF BIT DEPTH


gisine		ftgen	0, 0, 4096, 10, 1						;FUNCTION TABLE THAT STORES A SINGLE CYCLE OF A SINE WAVE
giExp20000	ftgen	0, 0, 129, -25, 0, 20.0, 128, 20000.0		;TABLES FOR EXP SLIDER


instr	10	;GUI
	ktrig	metro	10
	if (ktrig == 1)	then
		kbasefreq		invalue 	"Base_Frequency"
		gkbasefreq	tablei	kbasefreq, giExp20000, 1
					outvalue	"Base_Frequency_Value", gkbasefreq		
		gkindex		invalue 	"Modulation_Index"
		gkCarRatio	invalue	"Carrier_Frequency"
		gkModRatio	invalue	"Modulator_Frequency"
		gkCarAmp		invalue 	"Carrier_Amplitude"
		gkndxatt		invalue 	"Index_Attack"
		gkndxdec		invalue 	"Index_Decay"
		gkndxslev		invalue 	"Index_Sustain"
		gkndxrel		invalue 	"Index_Release"
		gkndxdel		invalue 	"Index_Delay"
		gkampatt		invalue 	"Amp_Attack"
		gkampdec		invalue 	"Amp_Decay"
		gkampslev		invalue 	"Amp_Sustain"
		gkamprel		invalue 	"Amp_Release"
		gkampdel		invalue 	"Amp_Delay"
	endif
endin

instr	1	;FM INSTRUMENT
	if p4!=0 then													;MIDI
		ioct		= p4												;READ OCT VALUE FROM MIDI INPUT
		iamp		= p5												;READ midi-velocity-amp FROM MIDI INPUT
		kCarAmp	= iamp * gkCarAmp									;SET AMPLITUDE TO RECEIVED p5 (I.E. MIDI VELOCITY) MULTIPLIED BY SLIDER "Carrier_Amplitude"

		;PITCH BEND===========================================================================================================================================================
		iSemitoneBendRange = 4										;PITCH BEND RANGE IN SEMITONES
		imin		= 0												;EQUILIBRIUM POSITION
		imax		= iSemitoneBendRange * .0833333						;MAX PITCH DISPLACEMENT (IN oct FORMAT)
		kbend	pchbend	imin, imax								;PITCH BEND VARIABLE (IN oct FORMAT)
		kbasefreq	=	cpsoct(ioct + kbend)							;SET FUNDEMENTAL FROM MIDI
		;=====================================================================================================================================================================
	else															;GUI
		kbasefreq = gkbasefreq										;SET FUNDEMENTAL FROM GUI SLIDER "Base_Frequency"
		kCarAmp	= gkCarAmp										;SET kamp TO SLIDER VALUE "Carrier_Amplitude"
	endif

	kporttime		linseg	0,0.001,0.02								;CREATE A VARIABLE FUNCTION THAT RAPIDLY RAMPS UP TO A SET VALUE	
	kbasefreq		portk	kbasefreq, kporttime

	kndxenv		madsr 	i(gkndxatt), i(gkndxdec), i(gkndxslev) + .0000001, i(gkndxrel) , i(gkndxdel)	;LINE SEGMENT ENVELOPE WITH MIDI RELEASE MECHANISM
	kpeakdeviation	=		kbasefreq * gkindex * kndxenv
	aModulator	oscili	kpeakdeviation, kbasefreq * gkModRatio,gisine
	kampenv 		mxadsr 	i(gkampatt), i(gkampdec), i(gkampslev) + .0000001, i(gkamprel) , i(gkampdel)	;EXPONENTIAL ENVELOPE WITH MIDI RELEASE MECHANISM
	aCarrier		oscili	kCarAmp * kampenv, (kbasefreq * gkCarRatio) + aModulator, gisine
				outs		aCarrier, aCarrier
endin

instr	2	;PRESET
	;OPCODE		DESTINATION		|   VALUE
	outvalue	 	"Carrier_Frequency",	p4
	outvalue	 	"Modulator_Frequency",	p5
	outvalue	 	"Base_Frequency",		p6
	outvalue	 	"Modulation_Index",		p7
	outvalue	 	"Index_Attack",		p8
	outvalue	 	"Index_Decay",			p9
	outvalue	 	"Index_Sustain",		p10
	outvalue	 	"Index_Release",		p11
	outvalue	 	"Index_Delay",			p12
	outvalue	 	"Amp_Attack",			p13
	outvalue	 	"Amp_Decay",			p14
	outvalue 		"Amp_Sustain",			p15
	outvalue 		"Amp_Release",			p16
	outvalue 		"Amp_Delay",			p17
endin
</CsInstruments>
<CsScore>
;INSTR | START | DURATION
i 10		0	   3600		;GUI
;INIT (Metal Plate)			| p4(CarRatio) | p5(ModRatio) | p6(BasFrq) | p7(index) | p8(NdxAtt) | p9(NdxDec) | p10(NdxSlev) | p11(NdxRel) | p12(NdxDel | p13(AmpAtt) | p14(AmpDec) | p15(AmpSlev) | p16(AmpRel) | p17(AmpDel)
i 2		0.1		0			1			1.377	0.4035705		5		.005			3		0			.5			0			.005		7			0			.5			0
</CsScore>
</CsoundSynthesizer>

<bsbPanel>
 <label>Widgets</label>
 <objectName/>
 <x>344</x>
 <y>184</y>
 <width>841</width>
 <height>494</height>
 <visible>true</visible>
 <uuid/>
 <bgcolor mode="background">
  <r>241</r>
  <g>226</g>
  <b>185</b>
 </bgcolor>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>2</x>
  <y>2</y>
  <width>512</width>
  <height>484</height>
  <uuid>{aa607456-d368-4d59-8497-d16d608404c3}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>                     Carrier -> Modulator, with envelopes</label>
  <alignment>center</alignment>
  <font>DejaVu Sans</font>
  <fontsize>18</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="background">
   <r>5</r>
   <g>27</g>
   <b>150</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>5</borderradius>
  <borderwidth>2</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>514</x>
  <y>2</y>
  <width>312</width>
  <height>348</height>
  <uuid>{74928ed2-b701-4668-9a11-74763d317e9b}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Carrier -> Modulator, with envelopes</label>
  <alignment>center</alignment>
  <font>DejaVu Sans</font>
  <fontsize>18</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="background">
   <r>5</r>
   <g>27</g>
   <b>150</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>5</borderradius>
  <borderwidth>2</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>520</x>
  <y>48</y>
  <width>305</width>
  <height>277</height>
  <uuid>{d4bdb5ce-87d8-4c8c-9c64-40ec2eed6f5a}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>-------------------------------------------------------------------------
To create more interesting timbres and to exploit FM synthesis's strengths the parameters involved in the synthesis should be dynamically modulated.
In this example an ADSR envelope is used to partly control the index of modulation Therefore varying the spectral intensity of the timbre as the note progresses.
(A second ADSR envelope is used to control the overall amplitude of the tone.)
Some presets are included to give the user some idea of what is possible, but bear in mind that this is still a very simple example.
This example is also playable from a MIDI keyboard if the 'MIDI' mode is active.</label>
  <alignment>left</alignment>
  <font>Liberation Sans</font>
  <fontsize>14</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBButton">
  <objectName/>
  <x>8</x>
  <y>6</y>
  <width>124</width>
  <height>30</height>
  <uuid>{24979132-c53f-4414-ac6b-6b4f503ecfe8}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <type>event</type>
  <pressedValue>1.00000000</pressedValue>
  <stringvalue/>
  <text> ON / OFF (MIDI)</text>
  <image>/</image>
  <eventLine>i 1 0 -1</eventLine>
  <latch>true</latch>
  <latched>false</latched>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Carrier_Amplitude</objectName>
  <x>448</x>
  <y>243</y>
  <width>60</width>
  <height>30</height>
  <uuid>{745d6bee-b951-4a03-9fe8-9e10d5ae4556}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>0.370</label>
  <alignment>right</alignment>
  <font>Arial</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBHSlider">
  <objectName>Carrier_Amplitude</objectName>
  <x>8</x>
  <y>220</y>
  <width>500</width>
  <height>27</height>
  <uuid>{06814721-6151-4baa-84e2-8f39843b07a4}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>1.00000000</maximum>
  <value>0.37000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>8</x>
  <y>243</y>
  <width>180</width>
  <height>30</height>
  <uuid>{c6d7165c-6730-426f-b293-52b411bc73cf}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Carrier Amplitude</label>
  <alignment>left</alignment>
  <font>Arial</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>130</x>
  <y>131</y>
  <width>234</width>
  <height>83</height>
  <uuid>{53a95371-23f7-4d54-a6c6-63bbabdb388d}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label/>
  <alignment>left</alignment>
  <font>Arial</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>229</x>
  <y>133</y>
  <width>32</width>
  <height>46</height>
  <uuid>{81ded06c-d53f-4a6d-a597-5f1b68b18042}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>:</label>
  <alignment>center</alignment>
  <font>Arial Black</font>
  <fontsize>27</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBSpinBox">
  <objectName>Carrier_Frequency</objectName>
  <x>150</x>
  <y>143</y>
  <width>70</width>
  <height>28</height>
  <uuid>{6f8fc775-201d-40f9-931b-687c9b3ef417}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <alignment>left</alignment>
  <font>Liberation Sans</font>
  <fontsize>14</fontsize>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <resolution>0.00010000</resolution>
  <minimum>0.125</minimum>
  <maximum>8</maximum>
  <randomizable group="0">false</randomizable>
  <value>1</value>
 </bsbObject>
 <bsbObject version="2" type="BSBSpinBox">
  <objectName>Modulator_Frequency</objectName>
  <x>273</x>
  <y>143</y>
  <width>70</width>
  <height>28</height>
  <uuid>{fd4b783c-f008-4a1c-b2e6-50340aad9093}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <alignment>left</alignment>
  <font>Liberation Sans</font>
  <fontsize>14</fontsize>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <resolution>0.00010000</resolution>
  <minimum>0.125</minimum>
  <maximum>8</maximum>
  <randomizable group="0">false</randomizable>
  <value>1.377</value>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>273</x>
  <y>172</y>
  <width>70</width>
  <height>50</height>
  <uuid>{d7a84933-3d3a-4adf-8289-84a4413362a7}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Modulator
Frequency</label>
  <alignment>center</alignment>
  <font>Arial</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>150</x>
  <y>172</y>
  <width>70</width>
  <height>50</height>
  <uuid>{7723878b-fcac-4444-84a2-a4ba87008431}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Carrier
Frequency</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>8</x>
  <y>67</y>
  <width>180</width>
  <height>30</height>
  <uuid>{541ace1b-b1de-4c04-8d84-1de90288dded}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Base Frequency</label>
  <alignment>left</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBHSlider">
  <objectName>Base_Frequency</objectName>
  <x>8</x>
  <y>44</y>
  <width>500</width>
  <height>27</height>
  <uuid>{eac88081-deaa-45c0-b896-32a3ffedc74a}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>1.00000000</maximum>
  <value>0.40357050</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Base_Frequency_Value</objectName>
  <x>448</x>
  <y>67</y>
  <width>60</width>
  <height>30</height>
  <uuid>{3be43919-ad18-4aef-b554-03c4b4d991c3}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>325.000</label>
  <alignment>right</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>8</x>
  <y>110</y>
  <width>180</width>
  <height>30</height>
  <uuid>{0c691576-66a5-4aa6-a82c-48f930da9708}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Modulation Index</label>
  <alignment>left</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBHSlider">
  <objectName>Modulation_Index</objectName>
  <x>8</x>
  <y>87</y>
  <width>500</width>
  <height>27</height>
  <uuid>{9cf53cef-488f-4075-b87f-dc2c3e6a21e6}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>20.00000000</maximum>
  <value>5.00000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Modulation_Index</objectName>
  <x>448</x>
  <y>110</y>
  <width>60</width>
  <height>30</height>
  <uuid>{aa79d499-9fd2-4387-89af-8e846c1081c4}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>5.000</label>
  <alignment>right</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>8</x>
  <y>284</y>
  <width>500</width>
  <height>96</height>
  <uuid>{edbaff47-a52a-4733-801b-10e207571428}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Index Envelope</label>
  <alignment>left</alignment>
  <font>Liberation Sans</font>
  <fontsize>14</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>Index_Attack</objectName>
  <x>189</x>
  <y>293</y>
  <width>45</width>
  <height>45</height>
  <uuid>{7020c475-84e1-497d-abcc-1651846cd081}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00500000</minimum>
  <maximum>8.00000000</maximum>
  <value>0.00500000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>177</x>
  <y>337</y>
  <width>70</width>
  <height>31</height>
  <uuid>{2bc5a26f-6ed1-497f-9cc9-372067fc74a0}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Attack</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Index_Attack</objectName>
  <x>182</x>
  <y>357</y>
  <width>60</width>
  <height>30</height>
  <uuid>{39ac87aa-d118-4cee-98a5-30005f1b85b9}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>0.005</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Index_Decay</objectName>
  <x>232</x>
  <y>357</y>
  <width>60</width>
  <height>30</height>
  <uuid>{e4a41d1d-7b92-4910-a33f-0505d9b85493}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>3.000</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>227</x>
  <y>337</y>
  <width>70</width>
  <height>31</height>
  <uuid>{738e097b-25dd-4f34-8279-6c7e03e83210}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Decay</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>Index_Decay</objectName>
  <x>239</x>
  <y>293</y>
  <width>45</width>
  <height>45</height>
  <uuid>{a92eed39-9f56-4cb4-bb3d-20f8c9ab692e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>15.00000000</maximum>
  <value>3.00000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Index_Sustain</objectName>
  <x>283</x>
  <y>356</y>
  <width>60</width>
  <height>30</height>
  <uuid>{c44e6e8e-a319-4ad7-936f-1dbad8fe5d88}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>0.000</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>278</x>
  <y>336</y>
  <width>70</width>
  <height>31</height>
  <uuid>{7fb72d6d-f804-4eed-8eec-03489eef4f54}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Sustain</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>Index_Sustain</objectName>
  <x>290</x>
  <y>292</y>
  <width>45</width>
  <height>45</height>
  <uuid>{1256d78b-64b4-4a33-b1a2-c6e147788a64}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>1.00000000</maximum>
  <value>0.00000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Index_Release</objectName>
  <x>334</x>
  <y>356</y>
  <width>60</width>
  <height>30</height>
  <uuid>{aede005f-af85-4a2e-826f-3b03c1a663a7}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>0.500</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>329</x>
  <y>336</y>
  <width>70</width>
  <height>31</height>
  <uuid>{84305d1c-9695-47f1-8536-0be4b8783ca7}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Release</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>Index_Release</objectName>
  <x>341</x>
  <y>292</y>
  <width>45</width>
  <height>45</height>
  <uuid>{bd1488b8-dfc0-48f8-80db-21f899f3408a}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>15.00000000</maximum>
  <value>0.50000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Index_Delay</objectName>
  <x>385</x>
  <y>356</y>
  <width>60</width>
  <height>30</height>
  <uuid>{80742be8-4ca4-4e7c-b845-5e6f911ce892}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>0.000</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>380</x>
  <y>336</y>
  <width>70</width>
  <height>31</height>
  <uuid>{70fbe521-a69d-45de-b056-52358ef4539f}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Delay</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>Index_Delay</objectName>
  <x>392</x>
  <y>292</y>
  <width>45</width>
  <height>45</height>
  <uuid>{ad8b5897-aaca-485d-b0f4-12723d84012a}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>8.00000000</maximum>
  <value>0.00000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>514</x>
  <y>350</y>
  <width>312</width>
  <height>136</height>
  <uuid>{d0e53040-2605-4b42-bb01-580909cc3849}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Presets</label>
  <alignment>center</alignment>
  <font>DejaVu Sans</font>
  <fontsize>18</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="background">
   <r>5</r>
   <g>27</g>
   <b>150</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>5</borderradius>
  <borderwidth>2</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>8</x>
  <y>382</y>
  <width>500</width>
  <height>96</height>
  <uuid>{ebccfe0c-c88a-475f-8960-eb0c68dc0465}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Amplitude Envelope</label>
  <alignment>left</alignment>
  <font>Liberation Sans</font>
  <fontsize>14</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBButton">
  <objectName/>
  <x>555</x>
  <y>391</y>
  <width>100</width>
  <height>30</height>
  <uuid>{59d7363f-ef65-48d5-9095-b9416211f693}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <type>event</type>
  <pressedValue>1.00000000</pressedValue>
  <stringvalue/>
  <text>Metal Plate</text>
  <image>/</image>
  <eventLine>i 2  0  0  1  1.377  0.4035705  5  .005  3  0  .5  0  .005  7  0  .5  0</eventLine>
  <latch>false</latch>
  <latched>false</latched>
 </bsbObject>
 <bsbObject version="2" type="BSBButton">
  <objectName>button1</objectName>
  <x>555</x>
  <y>430</y>
  <width>100</width>
  <height>30</height>
  <uuid>{cbc62d10-c3dc-41ca-9387-093383525676}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <type>event</type>
  <pressedValue>1.00000000</pressedValue>
  <stringvalue/>
  <text>Clarinet</text>
  <image>/</image>
  <eventLine>i 2  0  0  1  2.0005  0.371262  5.33  .005  .715  .852  .111  0  .087  .402  .785  .102  0</eventLine>
  <latch>false</latch>
  <latched>true</latched>
 </bsbObject>
 <bsbObject version="2" type="BSBButton">
  <objectName>button1</objectName>
  <x>685</x>
  <y>391</y>
  <width>100</width>
  <height>30</height>
  <uuid>{a945af70-b97a-4a70-8361-dd75becac320}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <type>event</type>
  <pressedValue>1.00000000</pressedValue>
  <stringvalue/>
  <text>Trumpet</text>
  <image>/</image>
  <eventLine>i 2  0  0  1  1.0003  0.4372449  8.79  .005  .139  .616  .111  0  .018  .402  .785  .102  0</eventLine>
  <latch>false</latch>
  <latched>true</latched>
 </bsbObject>
 <bsbObject version="2" type="BSBButton">
  <objectName>button1</objectName>
  <x>685</x>
  <y>431</y>
  <width>100</width>
  <height>30</height>
  <uuid>{88201a85-55cc-4b46-95ca-e0d82f3e982c}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <type>event</type>
  <pressedValue>1.00000000</pressedValue>
  <stringvalue/>
  <text>Basson</text>
  <image>/</image>
  <eventLine>i 2  0  0  5  1  0.1706  5.33  .005  .715  .852  .111  0  .087  .402  .785  .102  0</eventLine>
  <latch>false</latch>
  <latched>true</latched>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>Amp_Delay</objectName>
  <x>392</x>
  <y>390</y>
  <width>45</width>
  <height>45</height>
  <uuid>{ba22dd34-221f-4885-be63-0227b478280f}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>8.00000000</maximum>
  <value>0.00000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>380</x>
  <y>434</y>
  <width>70</width>
  <height>31</height>
  <uuid>{cd2e5022-9b80-4261-b2cf-1327ea35b419}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Delay</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Amp_Delay</objectName>
  <x>385</x>
  <y>454</y>
  <width>60</width>
  <height>30</height>
  <uuid>{0ae5e1b4-46bc-456b-a7b6-d91b2d4196f9}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>0.000</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>Amp_Release</objectName>
  <x>341</x>
  <y>390</y>
  <width>45</width>
  <height>45</height>
  <uuid>{f94fee0f-a85f-49bc-92bb-1b449b5524b8}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>15.00000000</maximum>
  <value>0.50000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>329</x>
  <y>434</y>
  <width>70</width>
  <height>31</height>
  <uuid>{da15df18-48b8-43ab-a879-b4da10429f3a}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Release</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Amp_Release</objectName>
  <x>334</x>
  <y>454</y>
  <width>60</width>
  <height>30</height>
  <uuid>{ab141074-a7d2-4397-9da2-71162ac152c2}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>0.500</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>Amp_Sustain</objectName>
  <x>290</x>
  <y>390</y>
  <width>45</width>
  <height>45</height>
  <uuid>{a629f388-497b-45cd-a7d6-232a4699a56c}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>1.00000000</maximum>
  <value>0.00000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>278</x>
  <y>434</y>
  <width>70</width>
  <height>31</height>
  <uuid>{c109df79-b140-4292-bbb1-ae448090e932}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Sustain</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Amp_Sustain</objectName>
  <x>283</x>
  <y>454</y>
  <width>60</width>
  <height>30</height>
  <uuid>{ad993d2c-666e-4e49-8edc-b890b66c4b6a}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>0.000</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>Amp_Decay</objectName>
  <x>239</x>
  <y>391</y>
  <width>45</width>
  <height>45</height>
  <uuid>{d9a06f46-e411-492d-9402-3cb584ef32c4}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>15.00000000</maximum>
  <value>7.00000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>227</x>
  <y>435</y>
  <width>70</width>
  <height>31</height>
  <uuid>{eefade2c-bcf8-4fa7-83bd-e4d449daf2cd}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Decay</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Amp_Decay</objectName>
  <x>232</x>
  <y>455</y>
  <width>60</width>
  <height>30</height>
  <uuid>{d366e403-6bae-49e9-90b7-920e1ff2e8f0}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>7.000</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Amp_Attack</objectName>
  <x>182</x>
  <y>455</y>
  <width>60</width>
  <height>30</height>
  <uuid>{a8c5f4b0-7281-4c50-af8d-28fde5ff3d72}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>0.005</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>177</x>
  <y>435</y>
  <width>70</width>
  <height>31</height>
  <uuid>{ccdc65d8-5b7e-4745-96ef-5bb738bc55f3}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Attack</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>Amp_Attack</objectName>
  <x>189</x>
  <y>391</y>
  <width>45</width>
  <height>45</height>
  <uuid>{5971a2e0-a072-46fb-ba71-f5cf75fb8e71}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00500000</minimum>
  <maximum>8.00000000</maximum>
  <value>0.00500000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
</bsbPanel>
<bsbPresets>
</bsbPresets>
<MacOptions>
Version: 3
Render: Real
Ask: Yes
Functions: ioObject
Listing: Window
WindowBounds: 72 179 400 200
CurrentView: io
IOViewEdit: On
Options:
</MacOptions>

<MacGUI>
ioView background {61937, 58082, 47545}
ioText {2, 2} {512, 484} label 0.000000 0.00100 "" center "DejaVu Sans" 18 {65280, 65280, 65280} {1280, 6912, 38400} nobackground noborder                      Carrier -> Modulator, with envelopes
ioText {514, 2} {312, 348} label 0.000000 0.00100 "" center "DejaVu Sans" 18 {65280, 65280, 65280} {1280, 6912, 38400} nobackground noborder Carrier -> Modulator, with envelopes
ioText {520, 48} {305, 277} label 0.000000 0.00100 "" left "Liberation Sans" 14 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder -------------------------------------------------------------------------Â¬To create more interesting timbres and to exploit FM synthesis's strengths the parameters involved in the synthesis should be dynamically modulated.Â¬In this example an ADSR envelope is used to partly control the index of modulation Therefore varying the spectral intensity of the timbre as the note progresses.Â¬(A second ADSR envelope is used to control the overall amplitude of the tone.)Â¬Some presets are included to give the user some idea of what is possible, but bear in mind that this is still a very simple example.Â¬This example is also playable from a MIDI keyboard if the 'MIDI' mode is active.
ioButton {8, 6} {124, 30} event 1.000000 "" " ON / OFF (MIDI)" "/" i 1 0 -1
ioText {448, 243} {60, 30} display 0.370000 0.00100 "Carrier_Amplitude" right "Arial" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 0.370
ioSlider {8, 220} {500, 27} 0.000000 1.000000 0.370000 Carrier_Amplitude
ioText {8, 243} {180, 30} label 0.000000 0.00100 "" left "Arial" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Carrier Amplitude
ioText {130, 131} {234, 83} label 0.000000 0.00100 "" left "Arial" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 
ioText {229, 133} {32, 46} label 0.000000 0.00100 "" center "Arial Black" 27 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder :
ioText {150, 143} {70, 28} editnum 1.000000 0.000100 "Carrier_Frequency" left "" 0 {0, 0, 0} {63232, 62720, 61952} nobackground noborder 1.000000
ioText {273, 143} {70, 28} editnum 1.377000 0.000100 "Modulator_Frequency" left "" 0 {0, 0, 0} {63232, 62720, 61952} nobackground noborder 1.377000
ioText {273, 172} {70, 50} label 0.000000 0.00100 "" center "Arial" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder ModulatorÂ¬Frequency
ioText {150, 172} {70, 50} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder CarrierÂ¬Frequency
ioText {8, 67} {180, 30} label 0.000000 0.00100 "" left "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Base Frequency
ioSlider {8, 44} {500, 27} 0.000000 1.000000 0.403571 Base_Frequency
ioText {448, 67} {60, 30} display 324.999817 0.00100 "Base_Frequency_Value" right "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 325.000
ioText {8, 110} {180, 30} label 0.000000 0.00100 "" left "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Modulation Index
ioSlider {8, 87} {500, 27} 0.000000 20.000000 5.000000 Modulation_Index
ioText {448, 110} {60, 30} display 5.000000 0.00100 "Modulation_Index" right "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 5.000
ioText {8, 284} {500, 96} label 0.000000 0.00100 "" left "Liberation Sans" 14 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Index Envelope
ioKnob {189, 293} {45, 45} 8.000000 0.005000 0.010000 0.005000 Index_Attack
ioText {177, 337} {70, 31} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Attack
ioText {182, 357} {60, 30} display 0.005000 0.00100 "Index_Attack" center "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 0.005
ioText {232, 357} {60, 30} display 3.000000 0.00100 "Index_Decay" center "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 3.000
ioText {227, 337} {70, 31} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Decay
ioKnob {239, 293} {45, 45} 15.000000 0.000000 0.010000 3.000000 Index_Decay
ioText {283, 356} {60, 30} display 0.000000 0.00100 "Index_Sustain" center "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 0.000
ioText {278, 336} {70, 31} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Sustain
ioKnob {290, 292} {45, 45} 1.000000 0.000000 0.010000 0.000000 Index_Sustain
ioText {334, 356} {60, 30} display 0.500000 0.00100 "Index_Release" center "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 0.500
ioText {329, 336} {70, 31} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Release
ioKnob {341, 292} {45, 45} 15.000000 0.000000 0.010000 0.500000 Index_Release
ioText {385, 356} {60, 30} display 0.000000 0.00100 "Index_Delay" center "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 0.000
ioText {380, 336} {70, 31} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Delay
ioKnob {392, 292} {45, 45} 8.000000 0.000000 0.010000 0.000000 Index_Delay
ioText {514, 350} {312, 136} label 0.000000 0.00100 "" center "DejaVu Sans" 18 {65280, 65280, 65280} {1280, 6912, 38400} nobackground noborder Presets
ioText {8, 382} {500, 96} label 0.000000 0.00100 "" left "Liberation Sans" 14 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Amplitude Envelope
ioButton {555, 391} {100, 30} event 1.000000 "" "Metal Plate" "/" i 2  0  0  1  1.377  0.4035705  5  .005  3  0  .5  0  .005  7  0  .5  0
ioButton {555, 430} {100, 30} event 1.000000 "button1" "Clarinet" "/" i 2  0  0  1  2.0005  0.371262  5.33  .005  .715  .852  .111  0  .087  .402  .785  .102  0
ioButton {685, 391} {100, 30} event 1.000000 "button1" "Trumpet" "/" i 2  0  0  1  1.0003  0.4372449  8.79  .005  .139  .616  .111  0  .018  .402  .785  .102  0
ioButton {685, 431} {100, 30} event 1.000000 "button1" "Basson" "/" i 2  0  0  5  1  0.1706  5.33  .005  .715  .852  .111  0  .087  .402  .785  .102  0
ioKnob {392, 390} {45, 45} 8.000000 0.000000 0.010000 0.000000 Amp_Delay
ioText {380, 434} {70, 31} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Delay
ioText {385, 454} {60, 30} display 0.000000 0.00100 "Amp_Delay" center "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 0.000
ioKnob {341, 390} {45, 45} 15.000000 0.000000 0.010000 0.500000 Amp_Release
ioText {329, 434} {70, 31} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Release
ioText {334, 454} {60, 30} display 0.500000 0.00100 "Amp_Release" center "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 0.500
ioKnob {290, 390} {45, 45} 1.000000 0.000000 0.010000 0.000000 Amp_Sustain
ioText {278, 434} {70, 31} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Sustain
ioText {283, 454} {60, 30} display 0.000000 0.00100 "Amp_Sustain" center "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 0.000
ioKnob {239, 391} {45, 45} 15.000000 0.000000 0.010000 7.000000 Amp_Decay
ioText {227, 435} {70, 31} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Decay
ioText {232, 455} {60, 30} display 7.000000 0.00100 "Amp_Decay" center "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 7.000
ioText {182, 455} {60, 30} display 0.005000 0.00100 "Amp_Attack" center "Liberation Sans" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 0.005
ioText {177, 435} {70, 31} label 0.000000 0.00100 "" center "Liberation Sans" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Attack
ioKnob {189, 391} {45, 45} 8.000000 0.005000 0.010000 0.005000 Amp_Attack
</MacGUI>
<EventPanel name="" tempo="60.00000000" loop="8.00000000" x="913" y="162" width="655" height="346" visible="true" loopStart="0" loopEnd="0">    </EventPanel>
